/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.scheduler;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.scheduler.SchedulerTask;
import net.impactdev.impactor.api.scheduler.Ticks;
import net.impactdev.impactor.api.scheduler.v2.Scheduler;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.NotNull;

public class AsyncScheduler
implements Scheduler {
    private static final String THREAD_NAME = "Impactor Scheduler";
    private static final String WORKER_PREFIX = "Impactor Worker - ";
    private static final int PARALLELISM = 16;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, r -> {
        Thread thread2 = Executors.defaultThreadFactory().newThread(r);
        thread2.setName(THREAD_NAME);
        thread2.setDaemon(true);
        return thread2;
    });
    private final ForkJoinPool worker;

    public AsyncScheduler() {
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.worker = new ForkJoinPool(16, new WorkerThreadFactory(), new ExceptionHandler(), false);
    }

    @Override
    public Key key() {
        return Scheduler.ASYNCHRONOUS;
    }

    @Override
    public Executor executor() {
        return this.worker;
    }

    @Override
    public void publish(@NotNull Runnable action) {
        this.worker.execute(action);
    }

    @Override
    public SchedulerTask delayed(@NotNull Runnable action, @NotNull Ticks ticks) {
        return this.delayed(action, this.ticksToMillis(ticks), TimeUnit.MILLISECONDS);
    }

    @Override
    public SchedulerTask delayed(@NotNull Runnable action, @NonNegative long delay, @NotNull TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.worker.execute(action), delay, unit);
        return () -> future.cancel(false);
    }

    @Override
    public SchedulerTask repeating(@NotNull Runnable action, @NotNull Ticks ticks) {
        return this.repeating(action, this.ticksToMillis(ticks), TimeUnit.MILLISECONDS);
    }

    @Override
    public SchedulerTask repeating(@NotNull Runnable action, @NonNegative long interval, @NotNull TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.worker.execute(action), 0L, interval, unit);
        return () -> future.cancel(false);
    }

    @Override
    public SchedulerTask delayedAndRepeating(@NotNull Runnable action, @NotNull Ticks delay, @NotNull Ticks interval) {
        return this.delayedAndRepeating(action, this.ticksToMillis(delay), this.ticksToMillis(interval), TimeUnit.MILLISECONDS);
    }

    @Override
    public SchedulerTask delayedAndRepeating(@NotNull Runnable action, @NonNegative long delay, @NonNegative long interval, @NotNull TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.worker.execute(action), delay, interval, unit);
        return () -> future.cancel(false);
    }

    @Override
    public void shutdown() {
        this.shutdownExecutor();
        this.shutdownScheduler();
    }

    private void shutdownScheduler() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                BaseImpactorPlugin.instance().logger().severe("Timed out waiting for the Impactor scheduler to terminate");
                this.reportRunningTasks(thread2 -> thread2.getName().equals(THREAD_NAME));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void shutdownExecutor() {
        this.worker.shutdown();
        try {
            if (!this.worker.awaitTermination(10L, TimeUnit.SECONDS)) {
                BaseImpactorPlugin.instance().logger().severe("Timed out waiting for the Impactor worker thread pool to terminate");
                this.reportRunningTasks(thread2 -> thread2.getName().startsWith(WORKER_PREFIX));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void reportRunningTasks(Predicate<Thread> predicate) {
        Thread.getAllStackTraces().forEach((thread2, stack) -> {
            if (predicate.test((Thread)thread2)) {
                BaseImpactorPlugin.instance().logger().warn("Thread " + thread2.getName() + " is blocked, and may be the reason for the slow shutdown!\n" + Arrays.stream(stack).map(el -> "  " + String.valueOf(el)).collect(Collectors.joining("\n")));
            }
        });
    }

    private long ticksToMillis(Ticks ticks) {
        return ticks.ticks() * 50L;
    }

    private static final class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private static final AtomicInteger COUNT = new AtomicInteger(0);

        private WorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread thread2 = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread2.setDaemon(true);
            thread2.setName(AsyncScheduler.WORKER_PREFIX + COUNT.getAndIncrement());
            thread2.setContextClassLoader(Impactor.class.getClassLoader());
            return thread2;
        }
    }

    private static final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
    }
}

